//------------------------------------------------------------------------------
// To study Transient Response of given system.
//------------------------------------------------------------------------------


// OS : Windows 7
// Scilab : 6.0.1

clc
close
s=%s
// To form Numerator in form of wn^2
num = input('Enter the value of Numerator =')//num=16 
wn=sqrt(num)
// To form denominator in form of S^2+(2*zeta*wn)*s+wn^2
a= input('Enter the value of coefficient of term S^2 =')//a=1
b= input('Enter the value of coefficient of term S=')//b=1.6
den= [a*s^2+b*s+wn^2]
TF = syslin('c',num,den)//transfer function
disp(TF,"Transfer Function of system = ")
t=0:0.1:10; 
y1 = csim('step', t, TF);//time response
title('Transient Response of given system');
xlabel('Time ----------->');
ylabel('C(t)------------>');
plot(t, y1)
disp(wn,"Value of wn =")
z=b/(2*wn)
disp(z,"Value of zeta =")
if z<1 then
    disp("----------------------")
    disp("system Is Under Damped")
    disp("----------------------")
elseif z==1 then
    disp("----------------------")
    disp("system Is Critically Damped")
    disp("----------------------")
else
    disp("----------------------")
    disp("system Is Critically Damped")
    disp("----------------------")
    end
wd=wn*(sqrt(1-z^2));
disp(wd,"Damped frequency =")
theta=atan((sqrt(1-z^2)/z));
disp(theta, "Angle in radians=")
Tr = ((%pi-theta)/wd)
disp(Tr,"Rise TIme =")
Tp=%pi/wd
disp(Tp,"Peak TIme =")
Ts=4/(z*wn)
disp(Ts,"Settling Time =")
Mp=100*%e^((-z*%pi)/(sqrt(1-z^2)))
disp(Mp,"Peak overshoot % =")
